'use strict';

describe('Component: userDashboard', function () {
  beforeEach(module('genisis'));

  var $scope, $rootScope, $api, $user, $location, $window,
    $focus, $q;
  var controller, $componentController;

  beforeEach(inject(function (
    _$rootScope_,
    user,
    api,
    _$location_,
    _$window_,
    focus,
    _$q_,
    $injector
  ) {
    $rootScope = _$rootScope_;
    $scope = $rootScope.$new();
    $user = user;
    $api = api;
    $location = _$location_;
    $window = _$window_;
    $focus = focus;
    $q = _$q_;

    $componentController = $injector.get('$componentController');
    controller = $componentController('userDashboard', {});
  }));

  it('expects ctrl.user to be {}', function () {
    expect(controller.user).toEqual({});
  });

  it('expects ctrl.username to be null', function () {
    expect(controller.username).toEqual(null);
  });

  it('expects ctrl.lastRefreshedData to be {}', function () {
    expect(controller.lastRefreshedData).toEqual({});
  });

  it('expects ctrl.availableUseData to be false', function () {
    expect(controller.availableUserData).toEqual(false);
  });

  it('expects ctrl.lastRefreshedTime to be {}', function () {
    expect(controller.lastRefreshedTime).toEqual('');
  });

  describe('ctrl.submitSearch() function', function () {
    it('exists', function () {
      expect(controller.submitSearch).toBeDefined();
    });

    it('expects invalid form to return', function () {
      spyOn($window, 'alert');
      var form = {
        $valid: false
      };
      controller.submitSearch(form);
      expect(window.alert).toHaveBeenCalledWith(
        'Only alphanumeric characters are valid.'
      );
      expect(controller.username).toEqual(null);
    });

    it('expects method to return when no username', function () {
      spyOn($window, 'alert');
      var form = {
        $valid: true
      };
      controller.submitSearch(form);
      expect(window.alert).toHaveBeenCalledWith(
        'Please Enter a Username.'
      );
      expect(controller.username).toEqual(null);
    });

    it(
      'expects method promise to call window alert when failed response',
      function () {
        spyOn($window, 'alert');
        spyOn($api, 'retrieve').and.callFake(
          function () {
            var deferred = $q.defer();
            deferred.resolve({
              success: false,
              response: {},
              message: 'test'
            });
            return deferred.promise;
          }
        );
        var form = {
          $valid: true
        };
        controller.username = 'test';
        var promise = controller.submitSearch(form);
        promise.then(function (data) {
          expect(data.success).toEqual(false);
          expect(data.response).toEqual({});
          expect($window.alert).toHaveBeenCalledWith('test');
          expect(controller.username).toEqual(null);
        });
        expect($api.retrieve.calls.count()).toEqual(1);
      });

    it('expects success', function () {
      spyOn($api, 'retrieve').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {
              test: 'test'
            },
            message: 'test'
          });
          return deferred.promise;
        }
      );
      var form = {
        $valid: true
      };
      controller.username = 'test';
      var promise = controller.submitSearch(form);
      promise.then(function (data) {
        expect(data.success).toEqual(true);
        expect(data.response).toEqual({
          test: 'test'
        });
        expect(controller.availableUserData).toEqual(true);
        expect(controller.user).toEqual({
          test: 'test'
        });
        expect($focus).toHaveBeenCalledWith(
          'sysAdminDashHeader');
      });
      expect($api.retrieve.calls.count()).toEqual(1);
    });
  });

  describe('ctrl.refreshUsers() function', function () {
    it('exists', function () {
      expect(controller.refreshUsers).toBeDefined();
    });

    it('expects to return window alert if response is unsuccessful',
      function () {
        spyOn($api, 'retrieve').and.callFake(function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            response: {},
            message: 'test'
          });
          return deferred.promise;
        });
        spyOn($window, 'alert');
        var promise = controller.refreshUsers();
        promise.then(function (data) {
          expect(controller.lastRefreshedData).toEqual({});
          expect($window.alert).toHaveBeenCalledWith(data.message);
        });
        expect($api.retrieve.calls.count()).toEqual(1);
      });

    it('expects to successfully refreshUsers', function () {
      spyOn($api, 'retrieve').and.callFake(function () {
        var deferred = $q.defer();
        deferred.resolve({
          success: true,
          response: {
            test: 'test',
            lastRefreshed: 'test-time',
          },
          message: 'test'
        });
        return deferred.promise;
      });
      spyOn($window, 'alert');
      var promise = controller.refreshUsers();
      promise.then(function (data) {
        expect(controller.lastRefreshedData).toEqual(data.response);
        expect(controller.lastRefreshedTime)
          .toEqual(controller.lastRefreshedData.lastRefreshed);
      });
      expect($api.retrieve.calls.count()).toEqual(1);
    });
  });

  describe('ctrl.lastRefreshed() function', function () {
    it('exists', function () {
      expect(controller.lastRefreshed).toBeDefined();
    });

    it('expects to return window alert if response is unsuccessful',
      function () {
        spyOn($api, 'retrieve').and.callFake(function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            response: {},
            message: 'test'
          });
          return deferred.promise;
        });
        spyOn($window, 'alert');
        var promise = controller.lastRefreshed();
        promise.then(function (data) {
          expect(controller.lastRefreshedData).toEqual({});
          expect($window.alert).toHaveBeenCalledWith(data.message);
        });
        expect($api.retrieve.calls.count()).toEqual(1);
      });

    it('expects to successfully refreshUsers', function () {
      spyOn($api, 'retrieve').and.callFake(function () {
        var deferred = $q.defer();
        deferred.resolve({
          success: true,
          response: {
            test: 'test',
            lastRefreshed: 'test-time',
          },
          message: 'test'
        });
        return deferred.promise;
      });
      spyOn($window, 'alert');
      var promise = controller.lastRefreshed();
      promise.then(function (data) {
        expect(controller.lastRefreshedData).toEqual(data.response);
        expect(controller.lastRefreshedTime)
          .toEqual(controller.lastRefreshedData.lastRefreshed);
      });
      expect($api.retrieve.calls.count()).toEqual(1);
    });
  });
});